import { Component, OnInit, Injectable } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { Http, Response, Headers, RequestOptions } from '@angular/http';
import { IAppState } from '../../store';
import { BookmarkServices } from '../../services/bookmark-services';
import { SideNavigationService } from '../../services/side-navigation-service';
import { ConceptServices } from '../../services/concept-services';
import { 
  SET_DATA_ELEMENT_LIST } from '../../actions';

@Component({
  selector: 'app-data-element-list',
  templateUrl: './data-element-list.component.html',
  styleUrls: ['./data-element-list.component.scss']
})
export class DataElementListComponent implements OnInit {
  @select(['concepts', 'dataElements']) dataElements;
  @select(['system', 'focusedElement']) focusedElement;
  constructor(
    private ngRedux: NgRedux<IAppState>,
    private snService: SideNavigationService,
    private conceptService: ConceptServices) { }

  ngOnInit() {
    this.setDataElement();
  }

  getState() {
    return this.ngRedux.getState();
  }
 
  disableActive() {
    this.snService.disableActiveIcon('dataElementListIcon');
  }

  hasDataElements(dataElements) {
    return dataElements.length > 0;
  }

  setDataElement() {
    this.conceptService.getDataElementList()
      .subscribe((response: Response) => {
        if (response.status === 200) {
          const rdata = JSON.parse(response.text());
          this.ngRedux.dispatch({
            type: SET_DATA_ELEMENT_LIST,
            payload: rdata.response
          })
        }
      });
  }

  getElement(uri) {
    this.conceptService.getConcept(uri);
  }

}
